/*
   Make 4/2018
   https://www.heise.de/make/
   LED-Nixie Ansteuerung
   Liest die Uhrzeit aus einem RTC aus und stellt sie dar
*/

#include <Adafruit_NeoPixel.h>    // https://github.com/adafruit/Adafruit_NeoPixel
#include <DS3231.h>               // http://www.rinkydinkelectronics.com/library.php?id=73    ACHTUNG: Dies ist NICHT die Bibliothek, die ueber den Bibliotheksverwalter eingebunden werden kann! Ggf. vorher die andere Bibliothek entfernen oder lokalen Speicherort angeben ("")

const uint8_t PIN = 7;       // Datenpin. ca. 220-470 Ohm Widerstand zusaetzlich!
const uint8_t DIGITS = 2;    // Anzahl Digits à 20 LEDs

Adafruit_NeoPixel pixels = Adafruit_NeoPixel(DIGITS * 20, PIN, NEO_GRB + NEO_KHZ800);     // Konstruktor WS2812

struct RGB
{
  uint8_t red;
  uint8_t grn;
  uint8_t blu;
};

/*
 * @brief   Ausgabe einer Ziffer auf einerm Digit
 * @param   Digit (ab 0)
 *          Zahl (0..9)
 *          Farbe (RGB)
 * @return  none
 */
void OutDigit (uint8_t digit, uint8_t value, struct RGB* farbe)
{
  pixels.setPixelColor((digit * 20) + (value * 2), pixels.Color (farbe->red, farbe->grn, farbe->blu));
  pixels.setPixelColor((digit * 20) + (value * 2) + 1, pixels.Color (farbe->red, farbe->grn, farbe->blu));
}

/*
 * @brief   Ausgabe einer Zahl
 * @param   Zahl (0-65536)
 *          Farbe (RGB)
 *          Fuehrende Nullen anzeigen (0=nein, 1=ja)
 * @return  none
 */
void OutZahl (uint16_t value, struct RGB* farbe, uint8_t leadingZero)
{
  uint8_t pos=0;
  uint8_t i=0;

  for (i = 0; i <= 128; i++)
  {
    pixels.setBrightness(255 - i*2);
    pixels.show();
  }
  
  pixels.clear();   // alle Farbwerte loeschen

  if (((value >= 10000) || leadingZero) && DIGITS >= 5)    // Zehntausender
  {
    OutDigit (pos, (value / 10000) % 10, farbe);
    pos++;
  }
  
  if (((value >= 1000) || leadingZero) && DIGITS >= 4)    // Tausender
  {
    OutDigit (pos, (value / 1000) % 10, farbe);
    pos++;
  }
  
  if (((value >= 100) || leadingZero) && DIGITS >= 3)    // Hunderter
  {
    OutDigit (pos, (value / 100) % 10, farbe);
    pos++;
  }
  
  if (((value >= 10) || leadingZero) && DIGITS >= 2)    // Zehner
  {
    OutDigit (pos, (value / 10) % 10, farbe);
    pos++;
  }
  
  OutDigit (pos, value % 10, farbe);                    // Einer

  pixels.setBrightness(255);
  pixels.show();
}

void setup(){}

void loop()
{
  RGB farbe;
  DS3231  rtc(SDA, SCL);      // Init the DS3231 using the hardware interface
  Time zeit;

  pixels.begin();               // NeoPixel library initialisieren
  rtc.begin();                  // RTC initialisieren
  //rtc.setTime(12, 00, 0);     // Stellt RTC auf 12:00:00 (24-Stundenformat). Diesen Aufruf einmal ausfuehren (Kommentar entfernen, Zeit einstellen) und danach auskommentieren und erneut auf den Arduino uebertragen
  
  while (1)
  {
    zeit = rtc.getTime();             // Zeit auslesen
  
    farbe.red=250;                     // andere Farbe
    farbe.grn=0;
    farbe.blu=200;
    OutZahl (zeit.hour, &farbe, 1);      // Stunden ausgeben mit Default-Farbe
    delay(2500);

    
    farbe.red=10;                     // andere Farbe
    farbe.grn=80;
    farbe.blu=250;
    OutZahl (zeit.min, &farbe, 1);       // Minuten ausgeben
    delay(2500);
  }
}



