class Button {
  String label;
  int yPos, ySize = 80;
  Action action;
// --------------------------------------------------   
  Button(String label, int yPos) {
    this.label = label;
    this.yPos = yPos;
  }
// --------------------------------------------------   
  void setAction(Action action) {
    this.action = action;
  }
// --------------------------------------------------   
  void update() { 
    if (mouseInside()) {
      action.go();
    }
  }
 
  boolean mouseInside() { 
    return mouseX > 0
      && mouseX < width
      && mouseY > yPos
      && mouseY < yPos + ySize;
  }
// --------------------------------------------------   
  void draw() {
    fill(255);
    rect(0, yPos, width, ySize);
    fill(0);
    textSize(30);
    textAlign(CENTER, CENTER);
    text(label, 0, yPos, width, ySize);
  }
}