float red, green, blue, servo;
String ip = "192.168.1.111";
Button servoPlusButton;
Button servoMinusButton;
ColorPicker colorPicker;
// -------------------------------------------------- 
void setup() {
  size(540, 960);
  frameRate(10);
  servoPlusButton = new Button("servo +", width+10);
  servoPlusButton.setAction(new ServoPlusAction());
  servoMinusButton = new Button("servo -", width+190);
  servoMinusButton.setAction(new ServoMinusAction());
  colorPicker = new ColorPicker();
  colorPicker.setImage("bild.png");
  colorPicker.setAction(new ColorChangeAction());
}
// -------------------------------------------------- 
void draw() {
  background(red, green, blue);
  servoPlusButton.draw();
  servoMinusButton.draw();
  colorPicker.draw();
  showValue(servo, "Servo", width+100);
}
// -------------------------------------------------- 
void mousePressed() {
  servoPlusButton.update();
  servoMinusButton.update();
  colorPicker.update();
}
void showValue(float val, String label, int yPos) {
  fill(255);
    rect(0, yPos, width, 80);
    fill(0);
    textSize(30);
    textAlign(CENTER, CENTER);
    text(label + ": " +val, 0, yPos, width, 80);
}
// -------------------------------------------------- 
void sendValues() {
  try {
    loadStrings("http://" + ip 
    + "/red/" + red 
    + "/green/" + green 
    + "/blue/" + blue
    + "/servo/" + servo);
  } 
  catch (Exception e) {}
}