set datafile separator "\t"
set terminal svg size 1600,1024 font "Helvetica,20"
set output "heizung.svg"
set title "Temperatur- und Brennerverläufe Heizung"
set y2label "Temperatur [°C]"
set y2range [-20:80]
set y2tics 0,10
set ytics 0,20,100 nomirror
set ylabel "relative Brennerleistung [%]
set yrange [0:200]
set xlabel "Zeit [UTC]"
set xdata time
set xrange [time(0)-172800:time(0)]
set timefmt "%s"
set format x "%d.%m.\n%H:%M"
set key top left box opaque width -5
set grid xtics ytics y2tics
plot "datalog.csv" using 1:2 axis x1y2 title "Speicher oben" with lines,\
     "datalog.csv" using 1:3 axis x1y2 title "Speicher unten" with lines,\
     "datalog.csv" using 1:4 axis x1y2 title "Heizkreiszulauf" with lines,\
     "datalog.csv" using 1:5 axis x1y2 title "Heizungsvorlauf Soll" with lines,\
     "datalog.csv" using 1:6 axis x1y2 title "Heizungsvorlauf Ist" with lines,\
     "datalog.csv" using 1:8 axis x1y2 title "Außentemperatur" with lines,\
     "datalog.csv" using 1:7 axis x1y1 title "rel. Brennerleistung" with filledcurve x1
