//
//  NotificationService.swift
//  NotificationService
//
//  Created by Gero Gerber on 12/02/2017.
//  Copyright © 2017 Gero Gerber. All rights reserved.
//

import MobileCoreServices
import UserNotifications

class NotificationService: UNNotificationServiceExtension {

    var contentHandler: ((UNNotificationContent) -> Void)?
    var bestAttemptContent: UNMutableNotificationContent?

    override func didReceive(_ request: UNNotificationRequest, withContentHandler contentHandler: @escaping (UNNotificationContent) -> Void) {
        let url = URL(string: request.content.userInfo["my-image"] as! String)!
        
        self.contentHandler = contentHandler
        self.bestAttemptContent = (request.content.mutableCopy() as? UNMutableNotificationContent)
        
        URLSession.shared.downloadTask(with: url)
        {
            (location, response, error) in
            if let location = location
            {
                // Move temporary file to remove .tmp extension
                let mediaAttachment = try! UNNotificationAttachment(identifier: "media", url: location, options: [UNNotificationAttachmentOptionsTypeHintKey:kUTTypePNG])
                
                if let bestAttemptContent = self.bestAttemptContent
                {
                    // Modify the notification content here...
                    bestAttemptContent.attachments = [mediaAttachment]
                    contentHandler(bestAttemptContent)
                }
            }
        }.resume()
    }
    
    override func serviceExtensionTimeWillExpire() {
        // Called just before the extension will be terminated by the system.
        // Use this as an opportunity to deliver your "best attempt" at modified content, otherwise the original push payload will be used.
        if let contentHandler = contentHandler, let bestAttemptContent =  bestAttemptContent {
            contentHandler(bestAttemptContent)
        }
    }

}
