//
//  NotificationViewController.swift
//  NotificationContent
//
//  Created by Gero Gerber on 12/02/2017.
//  Copyright © 2017 Gero Gerber. All rights reserved.
//

import UIKit
import UserNotifications
import UserNotificationsUI

class NotificationViewController: UIViewController, UNNotificationContentExtension {

    @IBOutlet var label: UILabel?
    @IBOutlet weak var image: UIImageView?
    @IBOutlet weak var star: UIImageView?
    
    func didReceive(_ notification: UNNotification)
    {
        let content = notification.request.content
        
        if let attachment = content.attachments.first
        {
            if(attachment.url.startAccessingSecurityScopedResource())
            {
                let imageData = NSData(contentsOf: attachment.url)
                let localImage = UIImage(data: imageData! as Data)
                self.image?.image = localImage
                attachment.url.stopAccessingSecurityScopedResource()
            }
        }
    }
    
    func didReceive(_ response: UNNotificationResponse, completionHandler completion: @escaping (UNNotificationContentExtensionResponseOption) -> Void)
    {
        if response.actionIdentifier == "likeAction"
        {
            self.star?.isHidden = !(self.star!.isHidden)
            completion(.doNotDismiss)
        }
        else if let textResponse = response as? UNTextInputNotificationResponse
        {
            self.label?.text = textResponse.userText
            completion(.doNotDismiss)
        }
        else
        {
            completion(.dismiss)
        }
    }}
