//
//  ARQLCollectionViewController.swift
//  HeiseARKit2
//
//  Created by Gero Gerber on 29.08.18.
//  Copyright © 2018 Gero Gerber. All rights reserved.
//

import QuickLook
import UIKit

private let reuseIdentifier = "ARQLCell"

class ARQLCollectionViewController: UICollectionViewController {

    let itemsPerRow: CGFloat = 3
    var zoomView: UIView?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        navigationItem.title = "AR Quick Look USDZ Models"
        
        collectionView.allowsSelection = true
        collectionView.allowsMultipleSelection = false
    }
    
    // MARK: UIContentContainer
    
    override func viewWillTransition(to size: CGSize, with coordinator: UIViewControllerTransitionCoordinator) {
        super.viewWillTransition(to: size, with: coordinator)
        collectionView.collectionViewLayout.invalidateLayout()
    }
    
    // MARK: UICollectionViewDataSource

    override func numberOfSections(in collectionView: UICollectionView) -> Int {
        return 1
    }


    override func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return USDZItems.usdzItems.count
    }

    override func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: reuseIdentifier, for: indexPath) as! ARQLCollectionViewCell
    
        cell.imageView.image = UIImage(named: USDZItems.usdzItems[indexPath.item])
    
        return cell
    }

    // MARK: UICollectionViewDelegate

    override func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        zoomView = collectionView.cellForItem(at: indexPath)
        
        let previewController = QLPreviewController()
        previewController.dataSource = self
        previewController.delegate = self
        present(previewController, animated: true)
    }
    
    func previewController(_ controller: QLPreviewController, previewItemAt index: Int) -> QLPreviewItem {
        let selectedItemIndex = collectionView.indexPathsForSelectedItems![0].item
        return USDZItems.URLForItem(index: selectedItemIndex) as QLPreviewItem
    }
}

// MARK: UICollectionViewDelegateFlowLayout

extension ARQLCollectionViewController: UICollectionViewDelegateFlowLayout {
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        let availableWidth = collectionView.frame.width
        let widthPerItem = availableWidth / itemsPerRow
        
        return CGSize(width: widthPerItem, height: widthPerItem)
    }
}

// MARK: QLPreviewControllerDataSource

extension ARQLCollectionViewController: QLPreviewControllerDataSource {
    func numberOfPreviewItems(in controller: QLPreviewController) -> Int {
        return 1
    }
}

// MARK: QLPreviewControllerDelegate

extension ARQLCollectionViewController: QLPreviewControllerDelegate {
    func previewController(_ controller: QLPreviewController, transitionViewFor item: QLPreviewItem) -> UIView? {
        return zoomView
    }
}
