//
//  ViewController.swift
//  HeiseARKit2
//
//  Created by Gero Gerber on 24.07.18.
//  Copyright © 2018 Gero Gerber. All rights reserved.
//

import ARKit
import UIKit

class ViewController: UIViewController {

    @IBOutlet var serializeWorldMap: UIButton!
    @IBOutlet var scan3DObjects: UIButton!
    @IBOutlet var detect3DObjects: UIButton!
    @IBOutlet var imageTracking: UIButton!
    @IBOutlet var environmentTexturing: UIButton!
    @IBOutlet var quickLookUSDZ: UIButton!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        navigationItem.title = "ARKit 2"
        navigationController?.navigationBar.prefersLargeTitles = true
        
        serializeWorldMap.isEnabled = ARWorldTrackingConfiguration.isSupported
        scan3DObjects.isEnabled = ARObjectScanningConfiguration.isSupported
        detect3DObjects.isEnabled = ARWorldTrackingConfiguration.isSupported
        imageTracking.isEnabled = ARImageTrackingConfiguration.isSupported
        environmentTexturing.isEnabled = ARWorldTrackingConfiguration.isSupported
        quickLookUSDZ.isEnabled = ARWorldTrackingConfiguration.isSupported
    }
}

