//
//  GiphyResponse.swift
//  HeiseMultipeerConnectivity
//
//  Created by Gero Gerber on 26.02.19.
//  Copyright © 2019 Gero Gerber. All rights reserved.
//

import Foundation

struct GiphyImage: Codable {
    var mp4: String?
    var url: String?
    var width: String?
    var height: String?
}

struct GiphyData: Codable {
    var title: String
    var images: [String: GiphyImage]
}

struct GiphyPagination: Codable {
    enum CodingKeys: String, CodingKey {
        case count = "total_count"
    }
    
    var count: Int
}

struct GiphyMeta: Codable {
    var status: Int
}

struct GiphyResponse: Codable {
    var data: [GiphyData]
    var pagination: GiphyPagination
    var meta: GiphyMeta
}
