//
//  ServiceAdvertiser.swift
//  HeiseMultipeerConnectivity
//
//  Created by Gero Gerber on 19.02.19.
//  Copyright © 2019 Gero Gerber. All rights reserved.
//

import Foundation
import MultipeerConnectivity

class ServiceAdvertiser: NSObject {
    private let serviceAdvertiser: MCNearbyServiceAdvertiser
    private let sessionContainer: SessionContainer
    
    init(localPeer: LocalPeer, serviceType: String, sessionContainer: SessionContainer) {
        self.sessionContainer = sessionContainer
        serviceAdvertiser = MCNearbyServiceAdvertiser(peer: localPeer.peerId, discoveryInfo: nil, serviceType: serviceType)
        super.init()
        serviceAdvertiser.delegate = self
        serviceAdvertiser.startAdvertisingPeer()
        
        print("Started advertising service '\(serviceType)'")
    }    
}

extension ServiceAdvertiser: MCNearbyServiceAdvertiserDelegate {
    func advertiser(_ advertiser: MCNearbyServiceAdvertiser, didReceiveInvitationFromPeer peerID: MCPeerID, withContext context: Data?, invitationHandler: @escaping (Bool, MCSession?) -> Void) {
        print("Received invitation from '\(peerID.displayName)'")
        
        let session = self.sessionContainer.createSession()
        invitationHandler(true, session)
        
        print("Accepted invitation from '\(peerID.displayName)'")
    }
    
    func advertiser(_ advertiser: MCNearbyServiceAdvertiser, didNotStartAdvertisingPeer error: Error) {
        print("Advertising failed: \(error.localizedDescription)")
    }
}
