//
//  PeersTableViewController.swift
//  HeiseMultipeerConnectivity
//
//  Created by Gero Gerber on 19.02.19.
//  Copyright © 2019 Gero Gerber. All rights reserved.
//

import MultipeerConnectivity
import UIKit

class PeersTableViewController: UITableViewController {

    private var multipeerConnectivityProvider: MultipeerConnectivityProvider!
    private var remotePeers = Array<MCPeerID>()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        multipeerConnectivityProvider = AppDelegate.shared.multipeerConnectivityProvider        
    }
    
    override func viewDidAppear(_ animated: Bool) {
        multipeerConnectivityProvider.peersDelegate = self
        
        navigationController?.navigationBar.prefersLargeTitles = true
        title = "Peers"
    }
    
    func refresh() {
        remotePeers = Array(multipeerConnectivityProvider.remotePeers)
        tableView.reloadData()
    }
}

// MARK: - UIViewController

extension PeersTableViewController {
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if let destination = segue.destination as? SessionViewController {
            if let indexPath = tableView.indexPathForSelectedRow {
                destination.session = multipeerConnectivityProvider.enterSession(with: remotePeers[indexPath.row])
            }
        }
    }
}

// MARK: - UITableViewDataSource

extension PeersTableViewController {
    override func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return remotePeers.count
    }
    
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "PeerCell", for: indexPath)
        cell.textLabel?.text = remotePeers[indexPath.row].displayName
        return cell
    }
}

// MARK: - PeersDelegate

extension PeersTableViewController: PeersDelegate {
    func peerFound(peerID: MCPeerID) {
        refresh()
    }
    
    func peerLost(peerID: MCPeerID) {
        refresh()
    }
}
