/**************************************************************************
Name: FreeCommanderPortable 

Version: 2009.02b

Website: www.freecommander.com

Written for:
  NSIS 2.46 Unicode
  Required plugins: NewAdvSplash, Registry, FindProcDLL

License:
  Copyright? 2007 by Marek Jasinski & Franz Post

Acknowledgment:
 Implementation of this launcher would not have been possible without the
 execellent work done by John T. Haller and all people from the PortableApps
 community! Visit them at  http://portableapps.com
**************************************************************************/

!define FULLNAME "FreeCommander 2009 Portable"
!define NAME "FreeCommanderPortable"
!define APP "FreeCommander"
!define VER "2009.2.0.417"
!define PRODVER "2009.02b"
!define WEBSITE "www.freecommander.com"
!define DEFAULTEXE "FreeCommander.exe"
!define DEFAULTAPPDIR "FreeCommander"
!define DEFAULTSETTINGSPATH "settings"
!define StrStr "!insertmacro StrStr"

;=== Program Details
Name "${NAME}"
OutFile "..\..\${NAME}.exe"
Caption "${FULLNAME} | www.freecommander.com"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\English.nlf"
VIProductVersion "${VER}"
VIAddVersionKey /LANG=${LANG_ENGLISH} ProductName "${FULLNAME}"
VIAddVersionKey /LANG=${LANG_ENGLISH} Comments "Allows ${APP} to be run from a removable drive.  For additional details, visit ${WEBSITE}"
VIAddVersionKey /LANG=${LANG_ENGLISH} CompanyName "Marek Jasinski & contributors"
VIAddVersionKey /LANG=${LANG_ENGLISH} LegalCopyright "Marek Jasinski"
VIAddVersionKey /LANG=${LANG_ENGLISH} FileDescription "${FULLNAME}"
VIAddVersionKey /LANG=${LANG_ENGLISH} FileVersion "${VER}"
VIAddVersionKey /LANG=${LANG_ENGLISH} ProductVersion "${PRODVER}"
VIAddVersionKey /LANG=${LANG_ENGLISH} InternalName "${FULLNAME}"
VIAddVersionKey /LANG=${LANG_ENGLISH} LegalTrademarks "The software FreeCommander is property of the author: Marek Jasinski"
VIAddVersionKey /LANG=${LANG_ENGLISH} OriginalFilename "${NAME}.exe"

;=== Runtime Switches
XPStyle on
CRCCheck On
WindowIcon Off
SilentInstall Silent
AutoCloseWindow True
RequestExecutionLevel user

;=== Include
!include Registry.nsh
!include FileFunc.nsh
!insertmacro GetParameters

;=== Program Icon
Icon "..\..\App\AppInfo\appicon.ico"

;=== Icon & Stye ===
!define MUI_ICON "..\..\App\AppInfo\appicon.ico"

Var PROGRAMDIRECTORY
Var SETTINGSDIRECTORY
Var ADDITIONALPARAMETERS
Var EXECSTRING
Var PROGRAMEXECUTABLE
Var INIPATH
Var DISABLESPLASHSCREEN
Var ISDEFAULTDIRECTORY
Var SECONDARYLAUNCH
Var PortableAppRunning

!macro StrStr ResultVar String SubString
  Push `${String}`
  Push `${SubString}`
  Call StrStr
  Pop `${ResultVar}`
!macroend
 
Function StrStr
/*After this point:
  ------------------------------------------
  $R0 = SubString (input)
  $R1 = String (input)
  $R2 = SubStringLen (temp)
  $R3 = StrLen (temp)
  $R4 = StartCharPos (temp)
  $R5 = TempStr (temp)*/
 
  ;Get input from user
  Exch $R0
  Exch
  Exch $R1
  Push $R2
  Push $R3
  Push $R4
  Push $R5
 
  ;Get "String" and "SubString" length
  StrLen $R2 $R0
  StrLen $R3 $R1
  ;Start "StartCharPos" counter
  StrCpy $R4 0
 
  ;Loop until "SubString" is found or "String" reaches its end
  loop:
    ;Remove everything before and after the searched part ("TempStr")
    StrCpy $R5 $R1 $R2 $R4
 
    ;Compare "TempStr" with "SubString"
    StrCmp $R5 $R0 done
    ;If not "SubString", this could be "String"'s end
    IntCmp $R4 $R3 done 0 done
    ;If not, continue the loop
    IntOp $R4 $R4 + 1
    Goto loop
  done:
 
/*After this point:
  ------------------------------------------
  $R0 = ResultVar (output)*/
 
  ;Remove part before "SubString" on "String" (if there has one)
  StrCpy $R0 $R1 `` $R4
 
  ;Return output to user
  Pop $R5
  Pop $R4
  Pop $R3
  Pop $R2
  Pop $R1
  Exch $R0
FunctionEnd


Section "Main"
	  ;=== Find the INI file, if there is one
		IfFileExists "$EXEDIR\${NAME}.ini" "" CheckSubINI
			StrCpy "$INIPATH" "$EXEDIR"
			Goto ReadINI
			
	CheckSubINI:
		IfFileExists "$EXEDIR\${NAME}\${NAME}.ini" "" CheckSubSubINI
			StrCpy "$INIPATH" "$EXEDIR\${NAME}"
			Goto ReadINI
			
	CheckSubSubINI:
		IfFileExists "$EXEDIR\PortableApps\${NAME}\${NAME}.ini" "" CheckPortableAppsINI
			StrCpy "$INIPATH" "$EXEDIR\PortableApps\${NAME}"
			Goto ReadINI
			
	CheckPortableAppsINI:
		IfFileExists "$EXEDIR\Data\${NAME}\${NAME}.ini" ""  CheckOtherINI
			StrCpy "$INIPATH" "$EXEDIR\Data\${NAME}"
			Goto ReadINI
			
	CheckOtherINI:
		IfFileExists "$EXEDIR\Other\${NAME}Source\${NAME}.ini" ""  NoINI
			StrCpy "$INIPATH" "$EXEDIR\Other\${NAME}Source\"
			Goto ReadINI
			
	ReadINI:
		;=== Read the parameters from the INI file
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "ProgramDirectory"
		StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\$0"
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "SettingsDirectory"
		StrCpy "$SETTINGSDIRECTORY" "$EXEDIR\$0"
		;=== Check that the above required parameters are present
		IfErrors NoINI
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "AdditionalParameters"
		StrCpy "$ADDITIONALPARAMETERS" $0
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "ProgramExecutable"
		StrCpy "$PROGRAMEXECUTABLE" $0
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "DisableSplashScreen"
		StrCpy "$DISABLESPLASHSCREEN" $0
		
	;CleanUpAnyErrors:
		;=== Any missing unrequired INI entries will be an empty string, ignore associated errors
		ClearErrors
		;=== Correct PROGRAMEXECUTABLE if blank
		StrCmp $PROGRAMEXECUTABLE "" "" EndINI
			StrCpy "$PROGRAMEXECUTABLE" "${DEFAULTEXE}"
			Goto EndINI
			
	NoINI:
		;=== No INI file, so we'll use the defaults
		StrCpy "$ADDITIONALPARAMETERS" ""
		StrCpy "$PROGRAMEXECUTABLE" "${DEFAULTEXE}"
		StrCpy "$DISABLESPLASHSCREEN" "false"
		
		IfFileExists "$EXEDIR\App\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" CheckPortableProgramDIR
			StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\App\${DEFAULTAPPDIR}"
			StrCpy "$SETTINGSDIRECTORY" "$EXEDIR\Data\${DEFAULTSETTINGSPATH}"
			StrCpy "$ISDEFAULTDIRECTORY" "true"
			GoTo EndINI
			
		CheckPortableProgramDIR:
			IfFileExists "$EXEDIR\${NAME}\App\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" CheckPortableAppsDIR
			StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\${NAME}\App\${DEFAULTAPPDIR}"
			StrCpy "$SETTINGSDIRECTORY" "$EXEDIR\${NAME}\Data\${DEFAULTSETTINGSPATH}"
			GoTo EndINI
			
		CheckPortableAppsDIR:
			IfFileExists "$EXEDIR\PortableApps\${NAME}\App\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" CheckPortableAppsSplitDIR
			StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\PortableApps\${NAME}\App\${DEFAULTAPPDIR}"
			StrCpy "$SETTINGSDIRECTORY" "$EXEDIR\PortableApps\${NAME}\Data\${DEFAULTSETTINGSPATH}"
			GoTo EndINI
			
		CheckPortableAppsSplitDIR:
			IfFileExists "$EXEDIR\Apps\${NAME}\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" NoProgramEXE
			StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\Apps\${NAME}\${DEFAULTAPPDIR}"
			StrCpy "$SETTINGSDIRECTORY" "$EXEDIR\Data\${NAME}\${DEFAULTSETTINGSPATH}"
			
	EndINI:
			IfFileExists "$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" FoundProgramEXE
			
	NoProgramEXE:
		;=== Program executable not where expected
		MessageBox MB_OK|MB_ICONEXCLAMATION `$PROGRAMEXECUTABLE was not found.  Please check your configuration`
		
	FoundProgramEXE:
		;=== Check if already running
		StrCpy $SecondaryLaunch "false"
		FindProcDLL::FindProc "$PROGRAMEXECUTABLE"                 
		StrCmp $R0 "0" CheckForSettings		
		
	Test:
		FindWindow $1 "TfcForm" "" 0 $1
		IntCmp $1 0 CheckForSettings
			System::Call "user32::GetWindowText(i r1, t .r2) i."
			${StrStr} $3 $2 "FreeCommander  Portable"
			StrCmp $3 "FreeCommander  Portable" 0 Test
			StrCpy $SECONDARYLAUNCH "true"
		goto Test
		
	CheckForSettings:
		IfFileExists "$SETTINGSDIRECTORY\*.*" DisplaySplash
		;=== No settings found
		StrCmp $ISDEFAULTDIRECTORY "true" CopyDefaultSettings
		CreateDirectory $SETTINGSDIRECTORY
		Goto DisplaySplash
		
	CopyDefaultSettings:
		CreateDirectory "$EXEDIR\Data"
		CreateDirectory "$EXEDIR\Data\settings"
		CopyFiles /SILENT $EXEDIR\App\DefaultData\settings\*.* $EXEDIR\Data\settings
		
	DisplaySplash:
		StrCmp $SECONDARYLAUNCH "true" InitIni
		StrCmp $DISABLESPLASHSCREEN "true" InitIni
			;=== Show the splash screen before processing the files
			InitPluginsDir
			File /oname=$PLUGINSDIR\splash.jpg "${NAME}.jpg"	
			newadvsplash::show /NOUNLOAD 1200 0 0 -1 /BANNER $PLUGINSDIR\splash.jpg
			
	InitIni:
    StrCpY "$ADDITIONALPARAMETERS" "-i=$\"$SETTINGSDIRECTORY\FreeCommander.ini$\""
    IfFileExists "$SETTINGSDIRECTORY\FreeCommander.ini.new" "" DefaultIni
      CopyFiles /SILENT "$SETTINGSDIRECTORY\FreeCommander.ini.new" "$SETTINGSDIRECTORY\FreeCommander.ini"
      Sleep 200
      Delete "$SETTINGSDIRECTORY\FreeCommander.ini.new"

  DefaultIni:
		IfFileExists "$SETTINGSDIRECTORY\FreeCommander.ini" GetPassedParameters
			CopyFiles /SILENT "$SETTINGSDIRECTORY\FreeCommander.ini.default" "$SETTINGSDIRECTORY\FreeCommander.ini"		
			
	GetPassedParameters:
		;=== Get any passed parameters
		${GetParameters} $0
		StrCmp "'$0'" "''" "" LaunchProgramParameters
		;=== No parameters
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE"`
		Goto AdditionalParameters
		
	LaunchProgramParameters:
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" $0`
		
	AdditionalParameters:
		StrCmp $ADDITIONALPARAMETERS "" LaunchNow
		;=== Additional Parameters
		StrCpy $EXECSTRING `$EXECSTRING $ADDITIONALPARAMETERS`
		
	LaunchNow:
		StrCmp $SECONDARYLAUNCH "true" StartProgramAndExit
		ExecWait $EXECSTRING
		
	CheckRunning:
		Sleep 2000
		FindProcDLL::FindProc "$PROGRAMEXECUTABLE"
		StrCmp $R0 "0" NoMorePortableRunning
		StrCpy $PortableAppRunning "false"
		
	Loop:
		FindWindow $1 "TfcForm" "" 0 $1
		IntCmp $1 0 Done
			System::Call "user32::GetWindowText(i r1, t .r2) i."
			${StrStr} $3 $2 "FreeCommander  Portable"
			StrCmp $3 "FreeCommander  Portable" 0 Loop
			StrCpy $PortableAppRunning "true"
		goto Loop
		
	Done:
		StrCmp $PortableAppRunning "true" CheckRunning
		
	NoMorePortableRunning:	
		newadvsplash::stop /WAIT
		Goto TheEnd
		
	StartProgramAndExit:
		Exec $EXECSTRING
		
	TheEnd:
SectionEnd