##
# Find all .exe and .com Files 
# and generate a startup for Portable CommandPrompt
#
# Reiko Kaps <rek@ct.de> 2012

import shutil, sys, os, re

PathFolders = {}
BaseDir = r'D:\Benutzer\rek\Eigene Dokumente\projekte\netzwerkzeugkasten'
PortableDir = r'\PortableApps'
author = 'Reiko Kaps <rek@ct.de> 2012 - http://www.heise.de/netze'

## run on stick or on hdd, dont work !
(drive, path) = os.path.splitdrive(os.path.realpath(__file__))
print PortableDir + "\helper\\" + os.path.basename(__file__)

if path == PortableDir + "\helper\\" + os.path.basename(__file__) :
    BaseDir = drive
    print "Update: Run on Stick [%s] ..." % path
else:
    print "Update: Run on HDD [%s] ..." % path

## output filepath
outfile = BaseDir + PortableDir + r'\CommandPromptPortable\Data\Batch\commandprompt.bat'
if (os.path.isfile(outfile)):
    print "Backup last version ..."
    shutil.copy(outfile, outfile+".old")

print "Updating %s\n\n" % outfile

try:
    fp = open(outfile, 'w')
except IOError as e:
    print "I/O error({0}): {1}".format(e.errno, e.strerror)
except:
    print "Unexpected error:", sys.exc_info()[0]
    raise

##
# get Foldernames from directory
def GetFolders(currentdir, level=0):
     
    for file in os.listdir(currentdir):        
        if os.path.isdir(os.path.join(currentdir, file)):
            GetFolders(os.path.join(currentdir, file), level=level+1)
        ## looking for file ends .exe
        if os.path.isfile(os.path.join(currentdir, file)):
            (name, ext) = os.path.splitext(file)
            if ext == '.exe' or ext == '.com' or ext == '.bat':                                                            
                PathFolders[currentdir] = level            
    return

##
# print header
def Header():
    """Write the file header"""
    fp.write( "@echo off %debug%\n" )
    fp.write( "REM Startup-Datei for Commandprompt Portable\n" )
    fp.write( "REM autogenerated by %s \n" % os.path.basename(__file__) )
    fp.write( "REM %s\n" % author )
    fp.write( "\n\n" )
    fp.write( "pushd ..\.." )
    fp.write( "\n" )    
    fp.write( "if \"%cd%\" == \"%~d0\\\" (set subdir=%~d0\PortableApps) else (set subdir=%cd%\PortableApps)" )
    fp.write( "\npopd\n\n")
    fp.write( "set #=%subdir%\n" )
    fp.write( "set strlength=0\n" )
    fp.write( ":loop\n" )
    fp.write( "if defined # (set #=%#:~1%&set /A strlength += 1&goto loop)\n" )
    fp.write( "if %strlength% GTR 20 goto :FEHLER1\n\n" )
    return

##
# print Footer
def Footer():    
    fp.write( "\ncolor 17\n" )
    fp.write( "prompt $p$g\n" )
    fp.write( "title Portable Kommandozeile\n" )
    fp.write( "cls\n" )
    fp.write( "ver\n" )
    fp.write( "IF NOT DEFINED PROCESSOR_ARCHITEW6432 GOTO CPU32\n" )
    fp.write( "echo on a 64 Bit CPU\n" )
    fp.write( "goto ENDE\n" )

    fp.write( ":FEHLER1\n" )
    fp.write( "type \"%subdir%\CommandPromptPortable\Data\Batch\\fehler.txt\" \n" )
    fp.write( "echo Das Basisverzeichnis %subdir% enthaelt bereits %strlength% Zeichen\n" )
    fp.write( "echo.\n")
    fp.write( "goto :ENDE\n")
    
    fp.write( "\n:CPU32\n" )
    fp.write( "echo on a 32 Bit CPU\n")
    fp.write( ":ENDE\n" )
    fp.write( "echo c't Netzwerkzeugkasten\n" )
    fp.write( "echo Kommandoliste ... hilfe[ENTER]\n" )
    fp.write( "echo Suche ........... hilfe STICHWORT[ENTER]\n" )
    fp.write( "cd %subdir%\n" )
    return

## Main
if __name__ == "__main__":
    (path , base) =  os.path.split(BaseDir + PortableDir)
    (drive, dir) = os.path.splitdrive(path)
    full = os.path.join(drive, dir, base)

    GetFolders(full)

    ## print Header
    Header()

    ## sorting and printing
    # zuerst alles was 64 bit beherrscht 
    fp.write( "REM first all pathes with 64-bit-progs\n" )
    fp.write( "IF NOT DEFINED PROCESSOR_ARCHITEW6432 GOTO :32BIT\n\n" )

    for entry in sorted(PathFolders, key=PathFolders.get):    
        if (entry.find("64-Bit") > -1) or (entry.find("64-bit") > -1) or (entry.find("x64") > -1):
            fp.write( "set PATH=%PATH%;" + entry.replace(BaseDir+PortableDir, r'%subdir%') + "\n" )
        continue
    fp.write( "\n:32BIT\n" )

    ##
    # jetzt alle 32-Bit-Pfade

    for entry in sorted(PathFolders, key=PathFolders.get):
        if (entry.find("64-Bit") > -1) or (entry.find("64-bit") > -1) or (entry.find("x64") > -1):
            continue
        fp.write( "set PATH=%PATH%;" + entry.replace(BaseDir+PortableDir, r'%subdir%') + "\n")

    ## print Footer
    Footer()

    ## close fp
    try:
        fp.close()
    except IOError as e:
        print "I/O error({0}): {1}".format(e.errno, e.strerror)
    except:
        print "Unexpected error:", sys.exc_info()[0]
        raise

    print "Update -> Done!"
