#cs ----------------------------------------------------------------------------

 AutoIt Version: 3.3.8.1
 Author:         Reiko Kaps <rek@ct.de>	

 Script Function:
	Zeigt Textdatei an, einfache Suche 

#ce ----------------------------------------------------------------------------

#include <Array.au3>

Dim $filepath = @ScriptDir & "\kommandos.txt"
Dim $debug = 0

Local $file = FileOpen($filepath, 0)

; Check if file opened for reading OK
If $file = -1 Then
    ConsoleWriteError("Error: Can't find file kommandos.txt in the program folder " & @ScriptDir )
    Exit
EndIf
 
if $Cmdline[0] > 0 Then	
   ConsoleWrite("Stichwortsuche nach " & $cmdline[1] & ":" & @CRLF & @CRLF) 
EndIf

; get all lines in an array
Global $Lines[10][2] = [ ["Befehl", "Beschreibung"] ]
Dim $counter = 1

While 1
   Local $zeile = FileReadLine($file)
   If @error = -1 Then ExitLoop
   
   if $debug Then ConsoleWrite("Counter >" & $counter & "<" & @CRLF)
   if $counter = UBound($Lines) Then
	  ReDim $Lines[$counter+1][2]
   EndIf
   
   ; ignore empty or commented lines
   if not StringRegExp($zeile, "^\*.*") then
	  
	  local $parts = StringSplit($zeile, @TAB, 2)
	  if @error = 1 Then ContinueLoop
	  if $debug Then ConsoleWrite("Parts >" & $parts[0] & "< >" & $parts[1] & "<" & @CRLF)
	  if $debug Then ConsoleWrite(">" & $zeile & "<" & @CRLF)
	  $Lines[$counter][0] = $parts[0]
	  $Lines[$counter][1] = $parts[1]
	  $counter = $counter + 1
   EndIf   
WEnd

; Array sortieren
_ArraySort($Lines)
   
; Ausgabe
global $max = 0
global $min = 80
for $i=0 to UBound($Lines)-1
   local $current = StringLen($Lines[$i][0]) 
   if $current > $max then $max = $current
   if $current < $min then $min = $current   
Next

for $i=0 to UBound($Lines)-1
   ; Suche nach Stichwort
   if $Cmdline[0] > 0 Then	  
	  if not (StringRegExp($Lines[$i][0], $cmdline[1]) or StringRegExp($Lines[$i][1], "(?i)" & $cmdline[1])) then ContinueLoop
   EndIf
   ConsoleWrite($Lines[$i][0])
   for $j=StringLen($Lines[$i][0]) to $max+1
	  ConsoleWrite(" ")
   Next
   ConsoleWrite($Lines[$i][1] & @CRLF)
Next
FileClose($file)
Exit