#include "Adafruit_WS2801.h"
#include "SPI.h" // Comment out this line if using Trinket or Gemma
#ifdef __AVR_ATtiny85__
#include <avr/power.h>
#endif

#include <Wire.h>
#include "nunchuck_funcs.h"

/*****************************************************************************
Example sketch for driving Adafruit WS2801 pixels!


  Designed specifically to work with the Adafruit RGB Pixels!
  12mm Bullet shape ----> https://www.adafruit.com/products/322
  12mm Flat shape   ----> https://www.adafruit.com/products/738
  36mm Square shape ----> https://www.adafruit.com/products/683

  These pixels use SPI to transmit the color data, and have built in
  high speed PWM drivers for 24 bit color per pixel
  2 pins are required to interface

  Adafruit invests time and resources providing this open source code, 
  please support Adafruit and open-source hardware by purchasing 
  products from Adafruit!

  Written by Limor Fried/Ladyada for Adafruit Industries.  
  BSD license, all text above must be included in any redistribution

*****************************************************************************/
/*****************************************************************************
The Font used in this sketck is based on Matt LaGrandeur's Bitfonts
http://www.mattlag.com/bitfonts/
CC-SA 4.0 international license 
http://creativecommons.org/licenses/by-sa/4.0/
*****************************************************************************/
/*****************************************************************************
 * Nunchuck functions  -- Talk to a Wii Nunchuck
 *
 * This library is from the Bionic Arduino course : 
 *                          http://todbot.com/blog/bionicarduino/
 *
 * 2007-11 Tod E. Kurt, http://todbot.com/blog/
 *
 * The Wii Nunchuck reading code originally from Windmeadow Labs
 *   http://www.windmeadow.com/node/42
*****************************************************************************/
//This sketch controls a 5x6 Matrix of WS2801 Pixels (Data on Pin 11, Clock on Pin 12)
//The display can be controlled with a Wii-Nunchuck-Contoller  (Clock on Pin 2, Data on Pin 3)
//The marquee-text at the beginning can be set in the varible "glueckwunsch". All 26 letters and 10 digits are available

uint8_t dataPin  = 11;    // Yellow wire on Adafruit Pixels
uint8_t clockPin = 12;    // Green wire on Adafruit Pixels

// Set the first variable to the NUMBER of pixels. 25 = 25 pixels in a row
Adafruit_WS2801 strip = Adafruit_WS2801(30, dataPin, clockPin);

uint32_t frame[5][6];
byte accx,accy,zbut,cbut,joyx,joyy;
byte font55[][5]={
{31,16,20,16,31},   //0
{12,4,4,4,31},      //1
{31,1,31,16,31},    //2
{31,1,31,1,31},     //3
{17,17,31,1,1},     //4
{31,16,31,1,31},    //5
{31,16,31,17,31},   //6
{31,1,3,1,1},       //7
{31,17,31,17,31},   //8
{31,17,31,1,1},     //9
{14,17,31,17,17},   //A=10
{30,17,30,17,30},   //B=11
{15,16,16,16,15},   //C=12
{30,17,17,17,30},   //D=13
{31,16,28,16,31},   //E=14
{31,16,28,16,16},   //F=15
{15,16,22,17,15},   //G=16
{17,17,31,17,17},   //H=17
{31,4,4,4,31},      //I=18
{31,1,1,17,14},     //J=19
{17,17,30,17,17},   //K=20
{16,16,16,16,31},   //L=21
{27,21,21,17,17},   //M=22
{25,21,21,21,19},   //N=23
{14,17,17,17,14},   //O=24
{30,17,30,16,16},   //P=25
{14,17,17,21,15},   //Q=26
{14,17,31,20,19},   //R=27
{15,16,14,1,30},    //S=28
{31,4,4,4,4},       //T=29
{17,17,17,17,14},   //U=30
{17,17,9,5,3},      //V=31
{17,17,21,21,27},   //W=32
{17,17,14,17,17},   //X=33
{17,17,14,4,4},     //Y=34
{31,1,14,16,31},     //Z=35
{0,0,0,0,0}         //Blank=36
};

void setup() {
#if defined(__AVR_ATtiny85__) && (F_CPU == 16000000L)
  clock_prescale_set(clock_div_1); // Enable 16 MHz on Trinket
#endif


  strip.begin();

  // Update LED contents, to start they are all 'off'
  strip.show();
  nunchuck_init(); // send the initilization handshake
}


void loop() {

  marqee();
  supermario();

}

void marqee()
{
  byte glueckwunsch[]={10,21,21,14,28,36,16,30,29,14,36,35,30,22,36,16,14,11,30,27,29,28,29,10,16,36,36,36};
  nunchuck_get_data();
  cbut = nunchuck_cbutton();
  while(cbut==0)
  {
    nunchuck_get_data();
    cbut = nunchuck_cbutton();
    
    for (int i=0; i<5; i++)
    {
      for (int j=0; j<6; j++)
      {
        frame[i][j]=0;
      }
    }
    int now=round(millis()/1000)%sizeof(glueckwunsch);
    if (glueckwunsch[now]<36)
    {
      for (int i=0; i<5; i++)
      {
        int temp=font55[glueckwunsch[now]][i];
        for (int j=0; j<6; j++)
        {
          temp=font55[glueckwunsch[now]][i]>>j;
          if (temp&00000001){
            frame[i][j]=Color(255,random(40,60),0);
          }
        }
      }
    }
    imwrite();  
  }
}


void supermario() 
{
  long oldmillis=millis();
  long oldmovemillis=millis();
  int framemillis=50;
  byte level[][11]={  {255,255,255,255,255},
                      {B10000000,B10000000,B10000110,B10001111,B11111110},
                      {0,0,B00110000,B10000110,0},
                      {0,B00001100,B00001111,B00001111,B11001111},
                      {0,0,128,B11111000,B11111111},
                      {0,0,0,2,B11111010},
                      {0,B00100000,B10001000,B10000010,128},
                      {0,B00100001,B01000001,B10001111,1},
                      {0,B11110000,B00001101,0,B11011111},
                      {B00001000,B00001111,B11101000,B00100010,255},
                      {0,254,B10001010,B00100000,255},
                      {1,1,1,B00100001,255},
                      {255,255,255,255,255}};
  int player[]={10,3}; //0,0 ist die linke obere Ecke
  byte cratestatus={B11111111};
  byte crateposition[][8]={{13,0},{22,1},{25,2},{32,0},{57,0},{61,1},{64,2},{85,2}};
  byte monsterstatus={B00011111};
  byte directions=B11011111; //Die obersten drei Bit sind für Plattformen (TRUE=hoch), die unteren fünf für Monster (TRUE=rechts)
  byte monsters[][5]={{37,3,37,44},{67,3,67,73},{78,2,78,78},{79,3,79,81},{83,3,83,89}};
  byte platforms[][2]={{26,2},{27,2}};
  byte lifes=3;
  boolean alive=true;
  byte fireballstatus=B000; //LSB zeigt an, ob Powerup verfügbar, LSB+1, ob Fireball abgefeuert und LSB+2 die Fireball-Richtung;
  byte fireball[][2]={{0,0},
                      {0,0}};
  byte powerup[]={64,3};
  byte finish[]={93,3};
  byte castle[][10]={{92,3},{92,2},{92,1},{92,0},{93,2},{93,1},{94,3},{94,2},{94,1},{94,0}};
  byte screenstartX=7;
  byte playerscreenX=0;
  byte score=0;
  int tempblock;
  byte jump=0;
  boolean inair=false;
  byte startblock, startbit;
  byte framecount=0;
  byte mask=0;
  while (lifes>0)
  {
    while (alive==true)
    {
      if (millis()>(oldmillis+framemillis))
      {
        framecount+=1;
        if (framecount==11) framecount=0;
        oldmillis=millis();
        nunchuck_get_data();
        zbut = nunchuck_zbutton();
        cbut = nunchuck_cbutton();
        joyx = nunchuck_joyx();
        joyy = nunchuck_joyy();
        playerscreenX=5-(player[0]-screenstartX);

        //Zeichnen der aktuellen Map
        startblock=screenstartX/8;  
        startbit=screenstartX%8;
        for (int i=0; i<5;i++)
        {
          tempblock=(level[startblock][i]<<8)+level[startblock+1][i];
        //  Serial.println(tempblock,BIN);
          for (int j=0; j<6;j++)
          { 
             if ( (((tempblock<<(5-j))>>(15-startbit))&1)  == true) frame[i][j]=Color(0,25,0);   
             else frame[i][j]=0;   
          }
        }
        
      
      
        //Von hier an kommt das Verhalten der Plattformen
        for (int i=0; i<2; i++)
        {
          
          if (framecount==0)
          {
            if (platforms[i][1]==4) bitWrite(directions,7-i,1);
            if (platforms[i][1]==1) bitWrite(directions,7-i,0);
            if ((directions>>(7-i))==1) 
            {
              if (player[0]==platforms[i][0])
              {
                if (player[1]==(platforms[i][1]-1)) player[1]-=1;
              }
              platforms[i][1]-=1;
            }
            if (bitRead(directions,7-i)==0) platforms[i][1]+=1;
/*            Serial.print("Status");
          Serial.print(directions);
          Serial.print("Plattform: ");
          Serial.print(platforms[i][0]-screenstartX);
          Serial.print(" y: ");
          Serial.println(platforms[i][1]);*/
          }
          if (((platforms[i][0]-screenstartX)<6)&&((platforms[i][0]-screenstartX)>=0))
          {
            frame[platforms[i][1]][5-(platforms[i][0]-screenstartX)]=Color(25,0,25);
//            Serial.print("Plattform!!  ");
  //          Serial.print(platforms[i][0]-screenstartX);
          }
        }
        
        //Von hier an kommt das Verhalten der Monster
        for (int i=0; i<5; i++)
        {
          mask=00000001;
          
          if (framecount==0)
          {
            if (monsters[i][0]==monsters[i][3]) bitWrite(directions,i,0);
            if (monsters[i][0]==monsters[i][2]) bitWrite(directions,i,1);
            if (i!=2) // Das Monster mit Index 2 ist stationär
              {
              if (bitRead(directions,i)==1) 
              {
                monsters[i][0]+=1;
              }
              if (bitRead(directions,i)==0) 
              {
                monsters[i][0]-=1;
              }
            }

          }
          if (((monsters[i][0]-screenstartX)<6)&&((monsters[i][0]-screenstartX)>=0))
          {
            if (bitRead(monsterstatus,i)==1) frame[monsters[i][1]][5-(monsters[i][0]-screenstartX)]=Color(25,0,0);

          }
        }
        
        //Jetzt kommen die Kisten
        for (int i=0; i<8; i++)
        { 
          if (bitRead(cratestatus,i)==1)
          {
            if (((5-(crateposition[i][0]-screenstartX))==playerscreenX)&&jump>0)
            {
              //Serial.println("bump");
              bitWrite(cratestatus,i,0);
              score+=1;
              //Serial.println(score);
            }
            if (((crateposition[i][0]-screenstartX)<6)&&((crateposition[i][0]-screenstartX)>=0))
            {
              frame[crateposition[i][1]][5-(crateposition[i][0]-screenstartX)]=Color(25,25,0);

            }
          }
        }
        
        //Jetzt kommt das Powerup
          if (bitRead(fireballstatus,0)==0)
          {
            if (((5-(powerup[0]-screenstartX))==playerscreenX)&&(powerup[1]==player[1])) bitWrite(fireballstatus,0,1);
            if (((powerup[0]-screenstartX)<6)&&((powerup[0]-screenstartX)>=0)) frame[powerup[1]][5-(powerup[0]-screenstartX)]=Color(25,5,25);
          }
        
        //Hier wird der Ausgang gezeichnet
        for (int i=0; i<10; i++)
        {
          if (((castle[i][0]-screenstartX)<6)&&((castle[i][0]-screenstartX)>=0)) frame[castle[i][1]][5-(castle[i][0]-screenstartX)]=Color(10,25,15);
          if (((finish[0]-screenstartX)<6)&&((finish[0]-screenstartX)>=0)) frame[finish[1]][5-(finish[0]-screenstartX)]=Color(25,15,25);
        }
        
        
        //Das hier ist der Feuerball
        if (bitRead(fireballstatus,0)==1)
        {
          //Serial.println("Feuerball verfügbar");
         if ((cbut>0)&&(bitRead(fireballstatus,1)==0)) 
         {
           Serial.print("Abgefeuert an Position");
           Serial.print(player[0]);
           Serial.print(" ");
           Serial.println(player[1]);
           bitWrite(fireballstatus,1,1);
           fireball[0][0]=player[0];
           fireball[0][1]=player[1];
           fireball[1][0]=player[0];
           fireball[1][1]=player[1];
         }
         if (bitRead(fireballstatus,1)==1)
         {
           Serial.println("Feuerball läuft");
           fireball[0][0]-=1;
           fireball[1][0]+=1;
           for (int i=0; i<2; i++)
           {
            bitWrite(fireballstatus,1,0);
            if (((fireball[i][0]-screenstartX)<6)&&((fireball[i][0]-screenstartX)>=0))
            {
              frame[fireball[i][1]][5-(fireball[i][0]-screenstartX)]=Color(0,10,25);
              bitWrite(fireballstatus,1,1);
            }
            for (int j=0; j<5; j++)
            {
       /*       Serial.print("Monstercheck");
                         Serial.print(j);
           Serial.print(" x ");
           Serial.print(monsters[j][0]);
           Serial.print(" y ");
           Serial.print(monsters[j][1]);
           Serial.print(" Feuerball x ");
           Serial.print(fireball[i][0]);
           Serial.print(" Feuerball y ");
           Serial.println(fireball[i][1]);
*/
              if ((fireball[i][0]==monsters[j][0])&&(fireball[i][1]==monsters[j][1]))
              {
                bitWrite(monsterstatus,j,0);
              }
            }
           }
         }
        }
        
        
        //Von hier an kommt das Handling der Sprünge
        if (frame[player[1]+1][playerscreenX]==0) inair=true;
        if (frame[player[1]+1][playerscreenX]!=0) inair=false; //Wenn unter der Spielfigur etwas ist, ist sie nicht mehr "in air";
        if ((jump==0)&&(zbut>0)) if (inair==false) 
        {
          Serial.print("Framefeld darüber: ");
          Serial.println(frame[player[1]-1][playerscreenX]);
/*          if ((frame[player[1]-1][playerscreenX]==0)||(player[1]==0))
          {
            jump=2;
            inair=true;
          }*/
//          if ((frame[player[1]-1][playerscreenX]==1644800)||(player[1]==0))
//          {
            jump=2;
            inair=true;
//          }
        }
        if (framecount%3==0)
        {  
          if (jump>0) 
          {
            if ((frame[player[1]-1][playerscreenX]==0)||(player[1]==0)) player[1]-=2;
            jump-=1;
          }
          if (frame[player[1]+1][playerscreenX]==0) player[1]+=1; //Falls unter der Spielfigur nichts ist, fällt diese eine Zeile runter
          if (player[1]<-1) player[1]+=1;  //Falls die Spielfigur mehr als eine Zeile über dem Bildschirm ist, fällt sie eine Zeile runter
        }
        /*
        Serial.print("Y-Position: ");
          Serial.print(player[1]);
          Serial.print(" Jump: ");
          Serial.print(jump);
          Serial.print(" In Air: ");
          Serial.println(inair);*/
          if (millis()>oldmovemillis+250)
          {
            oldmovemillis=millis();
            if (joyx<50)  if ((frame[player[1]][playerscreenX+1]==0)||(frame[player[1]][playerscreenX+1]==Color(10,25,15))||(frame[player[1]][playerscreenX+1]==Color(25,15,25))||(frame[player[1]][playerscreenX+1]==Color(25,5,25))) player[0]-=1;
            if (joyx>200) if ((frame[player[1]][playerscreenX-1]==0)||(frame[player[1]][playerscreenX-1]==Color(10,25,15))||(frame[player[1]][playerscreenX-1]==Color(25,15,25))||(frame[player[1]][playerscreenX-1]==Color(25,5,25))) player[0]+=1;
            if ((player[0]-screenstartX)<1) screenstartX-=1;
            if ((player[0]-screenstartX)>3) screenstartX+=1;
          }
      }
      
      
      if ((player[1]<5)&&(player[1]>=0)) frame[player[1]][playerscreenX]=Color(25,25,25); 
        if (player[1]>4) alive=false;
      if ((player[1]==finish[1])&&(player[0]==finish[0])){
        while (1){
          rainbow(20);  
        }
      }
      imwrite();
      /*Serial.print(player[0]);
      Serial.print(" ");
      Serial.print(player[1]);
      Serial.print(" ");
      Serial.print(player[0]-screenstartX);
      Serial.print(" ");
      Serial.print(screenstartX);
      Serial.print(" ");
      Serial.print(startblock);
      Serial.print(" ");
      Serial.println(startbit);*/
    }
  }
}

void imwrite()
{
  for (int i=0; i<5; i++)
  {
    for (int j=0; j<6; j++)
    {
      if ((i%2)==0)
      {
        strip.setPixelColor(i*6+j, frame[i][j]);
      }
      else
      {
        strip.setPixelColor(i*6+5-j, frame[i][j]);
      }
    }
  }
  strip.show();   // write all the pixels out
}

void rainbow(uint8_t wait) {
  int i, j;
   
  for (j=0; j < 256; j++) {     // 3 cycles of all 256 colors in the wheel
    for (i=0; i < strip.numPixels(); i++) {
      strip.setPixelColor(i, Wheel( (i + j) % 255));
    }  
    strip.show();   // write all the pixels out
    delay(wait);
  }
}

// Slightly different, this one makes the rainbow wheel equally distributed 
// along the chain
void rainbowCycle(uint8_t wait) {
  int i, j;
  
  for (j=0; j < 256 * 5; j++) {     // 5 cycles of all 25 colors in the wheel
    for (i=0; i < strip.numPixels(); i++) {
      // tricky math! we use each pixel as a fraction of the full 96-color wheel
      // (thats the i / strip.numPixels() part)
      // Then add in j which makes the colors go around per pixel
      // the % 96 is to make the wheel cycle around
      strip.setPixelColor(i, Wheel( ((i * 256 / strip.numPixels()) + j) % 256) );
    }  
    strip.show();   // write all the pixels out
    delay(wait);
  }
}

/* Helper functions */

// Create a 24 bit color value from R,G,B
uint32_t Color(byte r, byte g, byte b)
{
  uint32_t c;
  c = r;
  c <<= 8;
  c |= g;
  c <<= 8;
  c |= b;
  return c;
}

//Input a value 0 to 255 to get a color value.
//The colours are a transition r - g -b - back to r
uint32_t Wheel(byte WheelPos)
{
  if (WheelPos < 85) {
   return Color(WheelPos * 3, 255 - WheelPos * 3, 0);
  } else if (WheelPos < 170) {
   WheelPos -= 85;
   return Color(255 - WheelPos * 3, 0, WheelPos * 3);
  } else {
   WheelPos -= 170; 
   return Color(0, WheelPos * 3, 255 - WheelPos * 3);
  }
}
