import cv2
import numpy as np
import usb.core, usb.util, time


def MoveArm(Duration, ArmCmd):
#Start the movement
    RoboArm.ctrl_transfer(0x40,6,0x100,0,ArmCmd,1000)
#Stop the movement after waiting a specified duration
    time.sleep(0.1)
    ArmCmd=[0,0,0]
    RoboArm.ctrl_transfer(0x40,6,0x100,0,ArmCmd,1000)


# create video capture
cap = cv2.VideoCapture(0)

RoboArm = usb.core.find(idVendor=0x1267, idProduct=0x000)


if RoboArm is None:
    raise ValueError("Arm not found")
#Create a variable for duration
Duration=1

while(1):

    # read the frames
    _,frame = cap.read()

    # smooth it
    frame = cv2.blur(frame,(3,3))

    # convert to hsv and find range of colors
    hsv = cv2.cvtColor(frame,cv2.COLOR_BGR2HSV)
    #thresh = cv2.inRange(hsv,np.array((110, 50, 50)), np.array((130, 255, 255))) # blau
    #thresh = cv2.inRange(hsv,np.array((10, 100, 100)), np.array((30, 255, 255))) # gelb
    thresh = cv2.inRange(hsv,np.array((0, 150, 0)), np.array((5, 255, 255))) # rot

    #thresh2 = thresh.copy()

    # find contours in the threshold image
    # contours,hierarchy = cv2.findContours(thresh,cv2.RETR_LIST,cv2.CHAIN_APPROX_SIMPLE)

    # mit OpenCV3
    _, contours,hierarchy = cv2.findContours(thresh,cv2.RETR_LIST,cv2.CHAIN_APPROX_SIMPLE)

    # finding contour with maximum area and store it as best_cnt
    #best_cnt=0
    max_area = 0
    for cnt in contours:
        area = cv2.contourArea(cnt)
        if area > max_area:
            max_area = area
            best_cnt = cnt

    # finding centroids of best_cnt and draw a circle there
    if max_area > 0:
	M = cv2.moments(best_cnt)
	cx,cy = int(M['m10']/M['m00']), int(M['m01']/M['m00'])
	cv2.circle(frame,(cx,cy),5,255,-1)
	
	print cx,cy,"\n"
        
	if cx < 213:
	    	if cy >160 and cy < 320:
	          print "rechts\n"
	          MoveArm(1,[0,2,0]) #Rotate base anti-clockwise
        if cx > 426:
    		if cy >160 and cy < 320:
          	  print "links\n"
          	  MoveArm(1,[0,1,0])

    	if cy < 160:
    		if cx > 213 and cx < 426:
          	  print "hoch\n"
          	  MoveArm(1,[16,0,0]) #Elbow up
        
    	if cy > 320:
    		if cx > 213 and cx < 426:
          	  print "runter\n"
          	  MoveArm(1,[32,0,0]) #Elbow down

  	if cx < 213:
      		if cy < 160:
     		  print "greifer auf\n"
       		  MoveArm(1,[2,0,0]) #Grip open
   
    	if cx > 426:
      		if cy < 160:
        	  print "greifer zu\n"
        	  MoveArm(1,[1,0,0]) #Grip open

    	if cx < 213:
      		if cy > 320:
        	  print "Gelenk auf\n"
        	  MoveArm(1,[4,0,0]) #Gelenk
   

   	if cx > 426:
      		if cy > 320:
       		  print "Gelenk zu\n"
        	  MoveArm(1,[8,0,0]) #Gelenk
   
  	  	
	
    	
    cv2.line(frame,(0,160),(650,160),2,4,0)
    cv2.line(frame,(0,320),(650,320),2,4,0)
    cv2.line(frame,(213,0),(213,480),2,4,0)
    cv2.line(frame,(426,0),(426,480),2,4,0)	
    cv2.flip (frame, 1, frame)
    cv2.imshow('frame',frame)

    if cv2.waitKey(33)== 27:
        	break


# Clean up everything before leaving
cv2.destroyAllWindows()
cap.release()



