import bpy
import bpy_extras

class MyExport(bpy.types.Operator, bpy_extras.io_utils.ExportHelper):
    bl_idname = "export.myexport"
    bl_label = "Export Beispiel"

    # Attribute des ExportHelper
    filename_ext = ".txt"

    filter_glob = bpy.props.StringProperty(
            default="*.txt",
            options={'HIDDEN'},
            )

    # Attribute des Exporters
    use_setting = bpy.props.BoolProperty(
            name="Beispieleigenschaft",
            description="Beispiel Tooltip",
            default=True,
            )
            
    @classmethod
    def poll(cls, context):
        return context.object is not None

    def execute(self, context):
        print("running write_some_data...")
        f = open(self.filepath, 'w', encoding='utf-8')
        f.write("Hello World %s" % self.use_setting)
        f.close()
        return {'FINISHED'}

def menu_func_export(self, context):
    self.layout.operator(MyExport.bl_idname, text="Beispiel Export")


def register():
    bpy.utils.register_class(MyExport)
    bpy.types.INFO_MT_file_export.append(menu_func_export)


def unregister():
    bpy.utils.unregister_class(MyExport)
    bpy.types.INFO_MT_file_export.remove(menu_func_export)


if __name__ == "__main__":
    register()

    bpy.ops.export.myexport('INVOKE_DEFAULT')

