import bpy

scene = bpy.context.scene
    
bpy.types.Scene.MyIntProp = bpy.props.IntProperty(
    name = "IntProp", 
    description = "Integer eingeben")
scene['MyIntProp'] = 17

bpy.types.Scene.MyFloatProp = bpy.props.FloatProperty(
    name = "FloatProp", 
    description = "Float eingeben",
    default = 0.0,
    min = -100,
    max = 100)
 
bpy.types.Scene.MyBoolProp = bpy.props.BoolProperty(
    name = "BooleanProp", 
    description = "True oder False?")
scene['MyBoolProp'] = True
 
bpy.types.Scene.MyEnumProp = bpy.props.EnumProperty(
    items = [('ADD','Add','Adition'),
             ('SUB','Sub','Subtract'),
             ('MULT','Mult','Multiply'),
             ('DIV','Div','Divide')],
    name = "Aktion")
scene['MyEnumProp'] = 1
 
bpy.types.Scene.MyStringProp = bpy.props.StringProperty(
    name = "StringProp")
scene['MyStringProp'] = "Das ist ein Text"
 
class MyPropPanel(bpy.types.Panel):
    bl_label = "My Property panel"
    bl_space_type = "VIEW_3D"
    bl_region_type = "TOOL_PROPS"
 
    def draw(self, context):
        layout = self.layout
        scene = context.scene
        layout.prop(scene, 'MyIntProp')
        layout.prop(scene, 'MyFloatProp')
        layout.prop(scene, 'MyBoolProp')
        layout.prop(scene, 'MyEnumProp')
        layout.prop(scene, 'MyStringProp')

bpy.utils.register_module(__name__)
